# Future

# (1.8.1)
- BUGFIX/MENU: Fix menu rendering with Mali GPUs after changing video dimensions
- CDROM: Adds pregap support to cdfs helper methods
- CHEEVOS: Provides the new PCEngine hashing algorithm for RetroAchievements
- LOCALIZATION: Update French translation
- LOCALIZATION: Update Polish translation
- LOCALIZATION: Update Spanish translation
- MENU/MATERIALUI: Initial thumbnail support
- MENU/MATERIALUI: Cutie / Virtual Boy theme added
- MENU/MATERIALUI: Bugfix - Under certain extreme circumstances, entries with very long sublabel strings could have their text prematurely 'clipped' as the entry is scrolled beyond the top of the screen
- MENU/MATERIALUI: Bugfix - Certain setting value strings were unnecessarily truncated (with a ...) when using smooth ticker text
- MENU/XMB: Sunbeam theme added
- SWITCH: Accelerometer, gyroscope and illuminance sensor support
- VITA: Accelerometer and gyroscope sensor support

# (1.8.0)
- AI SERVICE: Added in fix for BMP returns to AI service. Added in label passing to AI service call
- BSV: Fix BSV recording/playback
- BUGFIX: Fix crash when setting Thumbnail Directory
- BUGFIX/STABILITY: Set "Automatically Add Content to Playlist" to false by default, this was unstable on PS3 and Mac and other platforms potentially as well.
- COMMON: Graceful driver switching for Windows and Linux
- COMMON: Cache frame before converting 0RGB1555
- LAKKA: Wi-Fi Access Point settings
- MENU: Menu scaling improvements
- MENU/MATERIALUI: There are no longer any animation glitches when 'wraparound' scrolling from the last entry in a list to the first, or when performing horizontal swipe navigation gestures on certain settings-type entries
- MENU/MATERIALUI: List entries underneath the title and navigation bars are no longer highlighted when touching the title/navigation bars (this was only a cosmetic issue, but it was annoying...)
- MENU/MATERIALUI: The current menu list is no longer reloaded when pressing the currently active tab on the navigation bar
- MENU/MATERIALUI: The ticker text spacer has been set to a 'bullet' character (same as Ozone)
- MENU/MATERIALUI: The default colour theme has been set to 'Ozone Dark'
- MENU/MATERIALUI: Three new colour themes have been added.
- MENU/MATERIALUI: A new Menu Transition Animation option has been added under User Interface > Appearance. When this is enabled, menu transition events are animated
- MENU/MATERIALUI: The navigation bar is now shown at all times - i.e. it is an actual navigation tool, rather than a 'top-level-menu' curiosity
- MENU/MATERIALUI: Two new context-sensitive buttons have been added to the navigation bar - back button and resume button
- MENU/MATERIALUI: A new Auto-Rotate Navigation Bar option has been added under User Interface > Appearance. When enabled (this is the default setting), the navigation bar is moved to the right hand side of the screen when using landscape screen orientations.
- MENU/MATERIALUI: The playlists tab is now correctly hidden when User Interface > Views > Show Playlist Tabs is disabled
- MENU/MATERIALUI: Material UI now correctly readjusts its layout when screen orientation changes on mobile devices
- MENU/MATERIALUI: Material UI now resizes in real-time when the user manually sets the Menu Scale Factor (this never worked properly with the old DPI override)
- MENU/MATERIALUI: Material UI no longer leaks memory on 'context reset' (fonts were previously never free()'d)
- MENU/MATERIALUI: A new Android-style 'system bar' has been added. This shows current core name, clock and battery level
- MENU/MATERIALUI: A new search icon is shown on the title bar when viewing playlists and file browser lists. Pressing this launches the search interface
- MENU/MATERIALUI: The title bar now uses a larger font, and the sublabel font has also been enlarged a little, to more closely align with Material UI standards
- MENU/MATERIALUI: A number (quite a large number) of layout/spacing issues have been fixed
- MENU/MATERIALUI: The existing colour theme handling code is not fit for purpose, so the whole lot got ripped out and reimplemented. In doing so, also adjusted all the theme colours to better match Material UI standards - with a few liberties taken for aesthetic purposes.
- OSD: Fix fast forward indicator when not using menu widgets
- PSP1: Remove duplicated FPS indicator on the screen
- SWITCH: Make audren threaded audio driver the new default
- VIDEO LAYOUT: Add video layout mame overlay compatibility. Enabled for Windows/Linux/OSX/iOS/Android/libnx. Only works with GL driver for now, no glcore yet

# (1.7.9) (v2)
- 3DS: Fix 3DS screen flickering when OSD is enabled
- IOS: Fix crash that could happen at startup
- MENU/MATERIALUI: Change DPI scaling back to original - too many issues with current implementation, requires a redesign

# (1.7.9)
- AI SERVICE: Image mode is now much faster, it now saves the image in-memory in PNG format then passes it along to the translation service
- BUGFIX: Touch input - When using an overlay to toggle the quick menu on touchscreen devices, we no longer get 'phantom' menu input - i.e. the old bug of hitting the toggle and instantly resuming content (or performing a save state) is fixed
- BUGFIX: Networking - RetroArch crashed when pressing left while Relay Server Location entry was selected 
- BUGFIX: Networking - fix memory leak that could happen at exit after a network
operation had run
- CHEEVOS: Improve handling of line endings when calculating CD hashes for retroachievements
- CHEEVOS: Add support for Sega CD/Saturn; reduce hash calls to server
- FPGA: Add initial FPGA port for Z-Turn boards - not really release-ready yet, will need community support to continue. Currently employs naive framebuffer approach, not fullspeed
- GL1: GLDirect (D3D9 to OGL1.1 wrapper) support
- GONG: Stability fixes
- LINUX/UDEV: Fix touchscreen/lightgun issues
- MENU/MATERIALUI: MaterialUI no longer 'forgets' its place when navigating backwards in menus, and navigation in general is 'cleaner'.
- MENU/MATERIALUI: Add initial gesture support
- MENU/MATERIALUI: Improved touch support
- MENU/MATERIALUI: Bugfix - Random' items are no longer automatically highlighted when performing standard up/down 'flick' scrolling through lists (items are only highlighted when you keep the pointer still for > 200 ms)
- MENU/MATERIALUI: Bugfix - The display no longer 'jerks' for one frame when navigating backwards through lists
- MENU/MATERIALUI: Bugfix - The Material UI scaling factor is now based upon the device-reported screen DPI value (previously it relied upon a hard-coded magic number, which was never correct)
- MENU/RGUI: Functional mouse/touchscreen support
- MENU/ONSCREEN KEYBOARD: On-screen keyboard entry via mouse/touchscreen has been tidied up - no more double inputs (or unwanted menu interaction in the background)
- MENU/MOUSE: Mouse wheel up/down is now a proper 'up/down', same as using cursor keys or a dpad
- MENU/MOUSE: Mouse wheel tilt left/right has been wired up to normal 'left/right' commands. Also further improved mouse wheel tilt
- MENU/OZONE: Add option to toggle between static and scrolling content metadata
- MENU/XMB: Add full gesture support
- MENU/OSX: Fixed mouse buttons - mouse down events were not hooked up
- MENU: When navigating backwards from a core options drop-down list (i.e. pressing select or cancel), the last menu position is remembered (instead of resetting back to the first core option item each time)
- MENU: Add mouse/touchscreen gesture support
- MENU: Add option to delete playlists (Settings > Playlists > Playlist Management)
- MOBILE (ANDROID/IOS): Add option to automatically rotate overlays when changing orientation
- OSD: Memory details should now be available on every platform (get_mem_total and get_mem_free need to be implemented in the frontend driver for it to work)
- OSD: Memory details can now be shown individually without FPS and frame count
- PS2: Fix memory leaks in font/video driver
- SWITCH: Set default aspect ratio to core provided instead of 4:3
- THREADED VIDEO: Fix FPS text in threaded video mode
- VITA: Set default aspect ratio to core provided instead of 4:3
- VITA: Add system language detection
- VITA: More memory support
- WIN32: Log window now has title 'Logging Console'
- WII: Add Wiimote lightgun support

# 1.7.8 (v4)
- COMMON: Enable customisation of runtime 'last played' display format.
- CHEEVOS:  Add hashing support for PSX (bin/cue, chd, or real CD) (for real this time, got added in the CHANGELOG for v2 then reverted before it hit release)
- IOS: Update for iOS 13, fix the asset packaging issues
- LOCALIZATION: Update Portuguese Brazilian Translation
- MENU: Add 12-hour time/date versions of all formats
- SWITCH: Add 'AI Service' option to Switch (untested)
- SWITCH: Update to newest libnx

# 1.7.8 (v3)
- GLCORE: Ensure correct scaling of menu texture (with RGUI)
- IPS: Soft-Patch any IPS size
- METAL: Fix overlay issue - setup correct viewport before rendering overlay
- METAL/STB: Fix font driver issue with AMD GPUs on MacOS.
- MENU/RGUI: Correctly rescale menu when resizing window if aspect ratio lock is enabled.
- OSX: Remove OSX suffix in window title
- PSP: Fix audio conversion code
- REMAPS: Fix analog remapping regression -analog remapping would break controls

# 1.7.8 (v2)
- 3DS: Fix 3DS startup crash
- AI SERVICE: Fix 'Japanese' setting
- D3D12: Fix runtime error at startup
- CHEEVOS: Fix Achievements badges
- CHEEVOS: Add hashing support for PSX (bin/cue, chd, or real CD)
- GLCORE: Fix regression - shaders don't work
- IOS: Use launch storyboard to properly support all screen sizes
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Korean translation
- LOCALIZATION: Update Polish translation
- MENU/XMB: Smooth vertical ticker scrolling
- OSX: Fix potential OSX startup crash
- PATCH: Fix IPS patches
- PLAYLISTS: Fix playlist heap corruption bug. Would also cause potential crashes on OSX and 3DS at startup
- SHADERS: Fix shader loading and saving in content-less cores
- SHADERS: Implement video_shader_delay setting. Screen grabbing software like streaming software can interfere with the loading of shaders, resulting in graphical glitches or freezes. This PR adds a video_shader_delay setting (in ms) and (advanced) menu entries Video -> Auto-Shader Delay, allowing to work around the issue


# 1.7.8
- 3DS: Fix C-Stick y-axis inversion
- 3DS: Update all icon/banner images
- AI: Add AI Service functionality (enabled for Windows/Mac/Linux/Android/iOS).
- APPLE (MAC/IOS/TVOS): Fix autodetect for mFI controllers: properly call autodetect add on the connect notification, and add call to disconnect on GameController disconnect notification.
- ANDROID: Implemented multi-touch touchscreen support
- ANDROID: Now can be built with Gradle/Android Studio
- AUDIO/WINDOWS: You can now select between audio devices for XAudio2/DirectSound/XAudio2 by pressing left/right on the Audio Device option.
- AUDIO/WINDOWS: Setting the device by either index number or name string should work.
- BLISS-BOX: Add 4 new pad types from firmware 3.0
- BPS/UPS: Re-allocation target_data variable for target patch size (can now apply bigger patches without extra-bytes on memory)
- CDROM: Added real CD-ROM functionality for Windows and Linux.
- CDROM: Added disc dumping.
- COMMON: Add separate frontend logging
- COMMON: Ability to set FPS update interval (used in the window titlebar/FPS widget)
- COMMON: Add 'Reset Frame Time Counter' functionality, enable it by default for resizing the window, loading/saving shader presets, fastforwarding, etc.
- COMMON: Add optional 'on demand' thumbnail downloads
- COMMON: Add new playlist-based thumbnail downloader. Hide the legacy thumbnail pack version by default
- COMMON: Show license per core (if available) inside 'Load Core'
- COMMON: Add option to load content from (and dump) CD-ROM discs
- COMMON: Re-enable '--log-file' command line option
- COMMON: Default playlist core association is now stored as metadata inside each playlist
- COMMON: Fix playlist format detection
- COMMON: Favorites playlist size can now be set independently of content history size. Values can be set from 0-999, or '-1' for unlimited (99999)
- COMMON: Prevent adding new items to favorites when playlist is full (old entries are no longer overwritten)
- COMMON: Prevent loading content with cores that require an incompatible graphics API version from the current one
- COMMON: Saved shader presets are now portable across platforms and use relative paths
- COMMON: Add '--set-shader' command line option which works like an override for automatic shader presets
- COMMON: Add global shader presets
- COMMON: Remove 'video_shader' setting, shaders are not saved automatically anymore
- CORE OPTIONS: When saving core option overrides, only include settings for the current core
- CORE OPTIONS: Add option to save core options per-core
- CPU FILTERS: Add Scanline2x filter
- DINPUT: Cleanup magic numbers mess surrounding hat code
- GAMECUBE: Add default video/audio filter directories
- GL/MALI400: Fix menu issues on Mali 400 series GPUs, should also fix 'RetroArch flickers black on ARM Mali GPUs (Android/ARM Linux)
- GL/GLCORE: Use highest supported OpenGL Core version on Windows and X11
- GL1: Ignore alpha in core video, fixes XRGB8888 rendering in some cores
- GLCORE: Don't hardcode shader cross compilation target version but poll it. glcore would always only use the minimum target shader version, i.e. GLSL ES 3.00 for OpenGL ES 3.0+ or GLSL 1.50 for OpenGL 3.2+
- D3D10/11/12/SLANG: Added "FrameDirection" slang semantic. Works fine with braid-rewind shader, not entirely perfect with D3D12 though
- D3D10/11/12: Add option to select which GPU to render with
- D3D10/11: Fix maintaining aspect ratio when resizing window
- GLCORE/SLANG: Added "FrameDirection" slang semantic
- HID: Add Retrode support. Should work on Wii/WiiU.
- INPUT: Menu toggle hotkey can now be bound to another keyboard key and it will toggle properly
- IOS: Correctly centers screen on iPhone X landscape
- IOS: Implemented multi-touch touchscreen support
- IOS: Add in more Apple Model numbers for RetroRating Added in all current Apple Model numbers and set a base rating of 19
- IOS: Remove pause indicator; show the native UI menu using 4-finger swipe down gesture
- IOS: Support L3/R3 in iOS 12.1, Options buttons in MFi/PS4/XBox One controllers in iOS 13
- LIBRETRO: Add new core options interface, allows for localization, sublabels and more
- LIBRETRO: Add new bitmask input codepath, for RETRO_DEVICE_ID_JOYPAD only for now
- LOCALIZATION: Update Korean translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Portuguese Brazilian Translation
- LOCALIZATION: Update Polish translation
- LOCALIZATION: Update Turkish translation
- MENU: Add smooth ticker text
- MENU: Ability to hide every settings submenu (User Interface -> Views -> Settings)
- MENU: Ability to hide nearly every quick menu entry (User Interface -> Views -> Quick Menu)
- MENU: Fix longstanding menu display issues on Mali400 GPUs (on ARM hardware, SBCs and mobile phones/tablets)
- MENU: Fix Record -> Streaming Quality, and Record -> Recording Threads settings
- MENU: Fix history playlist navigation after running content
- NENU: Menu entry performance optimisations
- MENU: Add option to show 'remove playlist entry' only on history/favourites
- MENU: Overhaul content 'Information' menu display
- MENU: Add new 'Playlist Management' submenu. Allows default core associations to be set (via dropdown list), and all existing associations to be reset
- MENU: Add 'Set Core Association' option to Quick Menu
- MENU: Add option to remain in menu after saving/loading states
- MENU: Pressing the Start button on 'Load Core' will unload the core.
- MENU: After a core is running, Load Core will be hidden from view until you select 'Close Content' from the Quick Menu.
- MENU/WIDGETS: All widgets are now properly cleaned up, fixing the frozen widgets bug when loading / closing content
- MENU/WIDGETS: Fix crash with tasks
- MENU/WIDGETS: Widgets are now drawn above the overlay with OpenGL and Vulkan
- MENU/WIDGETS: Fine tune progress bar colors
- MENU/WIDGETS: Have the progression widget always resize
- MENU/THUMBNAILS: Ensure that displayed thumbnails are always refreshed correctly after selecting 'Download Thumbnails' from Quick Menu
- MENU/THUMBNAILS: Make PNG image loading/processing non-blocking on non-threaded systems
- MENU/OZONE: Add it for PS3
- MENU/OZONE: Fix regression in 1.7.7 - OSX/macOS - was unable to start it
- MENU/OZONE: Fix sublabel spacing
- MENU/OZONE: Add toggle to enable/disable playlist name truncation in Ozone
- MENU/OZONE: (Ozone) Fix display of (semi-)transparent thumbnails
- MENU/XMB: Add menu animation settings
- MENU/XMB: Add optional thumbnail scaling
- MENU/XMB: Fix display of long sublabels. Text that would exceed the display area now scrolls line-by-line
- MENU/XMB/OZONE: Add optional thumbnail upscaling
- MENU/QT/WIMP: Add core option sublabels as tooltips, add buttons to reset one/all core options
- MENU/QT/WIMP: Word-wrap core option tooltips
- MENU/QT/WIMP: Path selector fixes
- MENU/RGUI: Enable playlist display on platforms without database support
- MENU/RGUI: Make particle effects framerate independent + add animation speed setting
- MIDI: correct pitch bend in ALSA driver - MIDI standard pitch bend center position is 0x2000 but ALSA's is 0
- MIDI: Fix SysEx handling. We need to clear the event status after each message. Otherwise, after a SysEx message the first byte of the next event will incorrectly inherit its delta_time. This causes a delay of several seconds in nearly every MT-32 games which uses a lot of long SysEx.
- METAL/SLANG: Added "FrameDirection" slang semantic
- NETBSD: Audioio is now the default audio driver
- NETBSD: Fix a segfault when starting RetroArch with an empty configuration file and LANG unset in the environment
- OSD: OSD is now drawn above the overlay with Vulkan
- OSX: Fix regression with Cocoa GL - shader / preset loading was getting stuck in an infinite loop
- OSX: Add improved menu resizing for window resizing
- PLAYLISTS: Add history/favourites to 'Playlist Management' menu
- RECORD: Fix Twitch streaming
- REMOTE RETROPAD: Fix for Remote RetroPad input - fixes processing of Remote RetroPad input. None of the remote inputs are being executed both in menu and in game. This is due to the way current key binds are being detected which block processing of any remote input. It's been tested using Remote RetroPad core on Android including digital dpad and analog control input.
- RUNAHEAD/MSVC2010:  Build in runahead support for MSVC2010 and up
- RUNAHEAD/VITA: Build in runahead support for Vita version
- SAVESTATES: Allow auto save states also in cores that support no content as long as some content is loaded
- SCALER: Fix SSE2 path for ARGB/BGRA -> BGR24 - should fix screenshots being taken for XRGB888 (viewport)
- SCANNER: Skip all databases with incompatible file extensions, whether content is inside an archive or not
- SCANNER: Fix hang on empty files inside archives
- SHADERS: Add proper shader compatibility checks
- SHADERS: Enable Cg shaders for D3D9
- SHADERS: Remove 'video_shader' setting, replace it with global presets that make more sense
- SHADERS: #reference directive for shaders. Presets can point to other existing presets if they are unchanged
- SHADERS: Will attempt to cache the shader/preset into memory before loading to avoid costly getline/gets/getc operations
- SHADERS: New --set-shader commandline option
- SHADERS/MENU: Prevent undefined behaviour when failing to load shaders
- SHADERS/MENU: Pressing the Start button on 'Load Shader Preset' will reset all shader passes and apply changes, effectively disabling the shaders
- SHADERS/MENU: New menu options for removing shader presets (global/core/parent/etc).
- SWITCH :Add Audren audio driver.
- SWITCH: Fix splitting and joining of joycon controllers. Before this fix, splitting and joining of joycons only ever worked sporadically
- SWITCH: Proper x/y scaling for pointer devices, fixes touch lightgun
- THUMBNAILS: Add optional On-Demand Thumbnails.
- UDEV: Fix wrong udev devices order
- UDEV/X11: Mouse pointer should work now in X11 environment with no Display
- VITA: Update Vita2D
- VULKAN/SLANG: Added "FrameDirection" slang semantic
- VULKAN: Add option to select which GPU to render with
- VULKAN: Validate non-causal filter chain for texture inputs. We only validated for UBO inputs apparently.
- WINDOWS: Menubar should no longer be disabled when threaded video is enabled
- WINDOWS: Add improved menu resizing for window resizing
- WINDOWS: Properly set initial directory for menubar 'Load Core' option
- WII: Add default video/audio filter directories
- WII: Fix RGUI display corruption
- WII: Fix HID joypad drivers
- WII: Add optional overscan correction
- WII: Fix recursive path_mkdir() operations
- WII: Add widescreen RGUI support
- WIIU: Scale menu to viewport size; respect filtering settings for menu
- WIIU/RGUI: RGUI does its own transparency effects in the texture, so we don't have to add another 50% on that
- WIIU/RGUI: Use correct pixelformat ordering for menu texture
- WIIU/SLANG: Added "FrameDirection" slang semantic
- X11: Add improved menu resizing for window resizing
- X11: Add non-evdev keycodes to fix keyboard input on non-Linux systems with X11

# 1.7.7
- 3DS: Add unique IDs to prevent cores overwriting each other
- 3DS: Fix screen tearing when running 50Hz content
- ANDROID: We now target API level 26 (minimum is still API level 9)
- ANDROID: Add option to vibrate on touch (works in menu or overlay)
- ANDROID: Add device vibration option for cores that support rumble
- ANDROID: Add gamepad vibration support for cores that support rumble
- ANDROID: Allow stylus/pen to move mouse without pressing down
- AUDIO: Avoid deadlocks in certain audio drivers when toggling menu sounds on
- BLISS-BOX: Support PSX Jogcon (requires firmware 3.0)
- CHEEVOS: Fix crash when reading memory that is out of range
- CHEEVOS: New Cheevos implementation enabled by default
- CHEEVOS: Pop-up badges when an achievement is triggered
- CRT: Dynamic super resolution support
- DISCORD: Fix potential crash when username is empty and discord is disabled
- DISCORD: Ask to join support for Linux
- INPUT/ANDROID: Add "Input Block Timeout" option
- COMMON: For platforms without HAVE_THREADS, don't automatically resume content when saving/loading states
- COMMON: Make playlist sorting optional and consistent
- COMMON: Fix sorting of playlists with blank labels
- COMMON: Fix content scanner creating false positive playlist entries that also have wrong label and crc32
- COMMON: Add some MMX-optimized pixel conversion routines
- COMMON: Fix typo preventing some SSE2-optimized pixel conversions from being used
- COMMON: Add option to track how long content has been running over time
- COMMON: Fix buffer overflows in system information
- COMMON: Add option to change screen orientation via the windowing system (Android, Windows, X11)
- COMMON: Show CPU model name in log
- COMMON: Add "Help -> Send Debug Info" option (and F10 hotkey) to send diagnostic info to the RetroArch team for help with problems
- COMMON: Show GPU device name/version in log
- COMMON: Add menu option to write log info to a file
- COMMON: Add subsystem support for playlists. Subsystem info is automatically saved to the history playlist for easy relaunching
- GL: Add new "gl1" OpenGL 1.1 compliant video driver for legacy GPUs and software renderers
- GL: Add a new "glcore" driver with slang support (requires GL 3.2+ or GLES3)
- GL: Draw OSD on top of overlay
- GONG: Add savestate support
- GONG: Add video refresh rate core options
- GONG: Two player support via core option
- GUI: Fix text alignment when using stb_unicode
- GUI: Fix text display issues when using Japanese (and other unicode-dependent language) text with stb_unicode
- GUI: Set language on first startup to the user's preferred OS language (Windows, *nix and Android)
- INPUT: Add (scaled radial) analog deadzone and sensitivity options
- LIBRETRO: Add Turkish language support
- LIBRETRO: Allow non-accelerated video to rotate the display
- LOCALIZATION: Update Chinese (Simplified) translation
- LOCALIZATION: Update Chinese (Traditional) translation
- LOCALIZATION: Update Dutch translation
- LOCALIZATION: Update French translation
- LOCALIZATION: Update German translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Polish translation
- LOCALIZATION: Update Russian translation
- LOCALIZATION: Update Spanish translation
- LOCALIZATION: Add new Turkish translation
- MIDI: Fix startup crash in midi driver
- MENU: Bugfix - you can no longer get stuck in Online Updater -> Update Core screen when toggling between ingame and menu
- MENU: Selectively hide 'Take Screenshot' for video drivers that don't support taking screenshots
- MENU: Framerate independent menu rendering. MaterialUI/Ozone/XMB/RGUI can now run at higher framerates
- MENU: Thumbnails work in history list
- MENU: Menu widgets
- MENU: Add memory statistics support to more context drivers
- MENU: Enable ozone driver for UWP builds
- MENU: Add optional "looping" menu text ticker with configurable speed
- MENU: Fix core video rendering when using ozone with GL cores that implement the scissor test
- MENU: Add optional playlist sublabels (associated core + play time, where available)
- MENU: Dropdown list settings now apply immediately
- MENU: Add setting to require pressing the "Exit RetroArch" hotkey twice to confirm
- MENU: Now able to run at higher refresh rates than 60Hz
- MENU: Enable "Add to Favorites" without loading a core
- MENU: Allow core name to be hidden on history/favorites playlists
- MENU: Populate crc32 and db_name fields when adding history/favourites playlist entries
- MENU: Fix TTF files not showing in OSD/menu font selection screen
- MENU: Fix audio/video filters not showing in file browser
- MENU/MaterialUI: Add subsystem support
- MENU/MaterialUI: Add currently selected entry in dropdown menus
- MENU/OZONE: Add mouse support on entries (no sidebar yet)
- MENU/OZONE: Allow collapsing the sidebar
- MENU/OZONE: Add thumbnail support
- MENU/OZONE: Battery notifications
- MENU/OZONE: Add wifi icon for network entries
- MENU/QT/WIMP: Add git version and build date to Help->About window
- MENU/QT/WIMP: Fix content loading via the file browser
- MENU/QT/WIMP: Add new settings window to control all RetroArch settings
- MENU/RGUI: Improve playlist titles
- MENU/RGUI: Add option to hide associated cores in playlists
- MENU/RGUI: Add internal upscaling option
- MENU/RGUI: Add subsystem support
- MENU/RGUI: Add menu sublabel support
- MENU/RGUI: Re-enable "Load Core" option when content is loaded
- MENU/RGUI: Add optional "Collections" entry to main menu
- MENU/RGUI: Add "Lock Menu Aspect Ratio" option
- MENU/RGUI: Add "full width" layout option
- MENU/RGUI: Ensure menu color theme is applied immediately
- MENU/RGUI: Fix "Lock Menu Aspect Ratio" option when using custom viewports
- MENU/RGUI: Add widescreen support
- MENU/RGUI: Allow text to be centred when selecting widescreen layouts
- MENU/RGUI: Add inline playlist thumbnail support
- MENU/RGUI: Add optional shadow effects
- MENU/RGUI: Performance optimizations
- MENU/RGUI: Add optional extended ASCII support
- MENU/RGUI: Add optional delay when loading thumbnails
- MENU/RGUI: Add on-screen keyboard
- MENU/RGUI: Battery notifications
- MENU/XMB: Prevent crashes when resizing to a tiny window
- MENU/XMB: XMB honors the 'show menu sublabels' setting now - was previously RGUI only
- NETPLAY: Fix stall-out causing total disconnection with >2 players
- NETPLAY: Different (more intuitive?) default netplay share policy
- NETPLAY: Add hotkey option to toggle hosting on/off
- NETWORKING: Encode URLs to allow for spaces in directory names
- OSX: Prevent crash on exit
- OSX: Metal is now the default video driver for the RetroArch Metal build
- OSX: Enable CoreAudio v3 driver for Metal
- OSX/MACOS/IOS: Now uses the STB Unicode font driver
- PS2: CDFS support
- PS2: Implemented analog support for ps2 controllers
- PS2: Fix audio freeze after restarting core
- PS2: Fix issues with load state and the font driver
- PS2: File I/O now works for USB and network host
- PS2: Support cores with extra padding in their frame buffers
- SCANNER: New option 'Scan without core match'. When this is enabled,
supported extensions by all installed cores are not checked, and instead
it will add all content it finds to a playlist. This way, you can install the core you need later on after scanning. Not enabled by default
- SHADERS: Don't alphabetize shader presets
- SWITCH: Add rumble support
- SWITCH: Add USB keyboard support
- VITA: Add bluetooth mouse and keyboard support
- VULKAN: Fix color issues with RGBA8888 swapchains in readback (screenshots)
- WII: Don't init overlay when RAM is beyond 72MB
- WII: Skip CRC calculation on content load, can improve load times of larger games by several seconds
- WINDOWS: Fall back to gl1 driver if accelerated GPU driver is unavailable
- WINDOWS: Allow winraw and xinput to work without dinput (needed for WinRT)
- WINDOWS: Add MSVC2017 ARM desktop support
- UWP: Fix rewind by opting for slower codepath
- UWP: Fix relative path name issues when loading shaders
- UWP: Optimizations for VFS system

# 1.7.6
- ANDROID: Fix Xperia Play input binding
- CHEEVOS: Reset when hardcore mode is toggled
- CHEEVOS: Update the hashing methods to identify NES, SNES and Lynx games (more accurate and accepting headerless ROMs)
- COMMON: Add new JSON playlist format
- COMMON: Fix playlist corruption when deleting items
- COMMON: Fix archive progress display calculation
- COMMON: Fix playlist entries appearing with previously used names
- COMMON: Fix screenshot filename with no core or content
- COMMON: Allow compiling without menu support
- CORE UPDATER: Allow sideloading cores from the menu
- CPU FILTERS: Add Normal2x filter
- CRT/LINUX: New Linux switching method partially implemented
- CRT/LINUX: Linux restore desktop resolution fixed
- CRT/LINUX: Monitor index switching and auto enumerate for output detection in Linux (still working on the windows method)
- CRT/RASPBERRY PI: Initial support
- DATE: Add Date / Time style options
- DEBUGGING: Add an integrated crash handler for debug builds (see https://docs.libretro.com/tech/debugging)
- DISCORD: Register the application name properly
- DISK CONTROL: Remember the last used folder / current active folder to make disk-swapping faster
- INPUT: Add new menu toggle (hold start button for 2 seconds)
- INPUT: Fix arrow keys being incorrectly bound as numpad keys
- INPUT/SDL: Flush the joypad events. Decreases cpu usage over time with the SDL joypad driver
- LOCALIZATION: Add Greek translation
- LOCALIZATION: Update German translation
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Simplified Chinese translation
- LOCALIZATION: Update Spanish translation
- MENU: New "ozone" menu driver
- MENU: Only show CRT SwitchRes if video display server is implemented (Windows/Linux for now)
- MENU: User Interface -> Appearance -> 'Menu Font Green/Blue Color' settings now work properly
- MENU: Add option to enable in-menu sound effects
- MENU/D3D: Scissoring support (will be used for Ozone and menu widgets)
- MENU/QT/WIMP: Allow building with MSVC2017
- MENU/QT/WIMP: Add detailed file browser table
- MENU/QT/WIMP: New grid view implementation that is faster and loads thumbnails on-demand
- MENU/QT/WIMP: Thumbnail drag and drop support
- MENU/RGUI: Overhaul custom theme interface + add wallpaper support
- MENU/RGUI: Thumbnail support and thumbnail downscaling
- MENU: Hide password values
- MENU/SOUNDS: Implement in-menu sound effects (not enabled by default for now, still experimental)
- MIDI: Add a Linux ALSA driver for MIDI
- NETPLAY: Force fast-save-states when netplay is enabled
- NETPLAY: Allow quick joining subsystem lobbies
- OSX: Initial CoreAudio V3 audio driver (not yet used in release builds)
- OSX: OpenGL 3.2 Core support for cores
- PS2: Initial PlayStation2 port
- PS4: Initial PlayStation4 port
- RECORDING: Implement recording options in the menu complete with quality profiles, streaming, and proper file naming
- SCANNER: Fix GDI disc scanning
- SHADERS: Fix auto shader preset loading on D3D10, D3D11, D3D12
- SUBSYSTEM: Allow more than 10 subsystems
- SUBSYSTEM: Cores that use subsystem for complex scenarios can now load content without starting a regular content first
- SUBSYSTEM: Remember the last used folder to make loading subsystem type content faster
- SWITCH/LIBNX: Improve touch scaling calculation
- SWITCH: Proper button labels
- TVOS: Initial tvOS port
- VULKAN: Fix RGUI crashing at startup
- VULKAN/RGUI: Enable 'Menu Linear Filter' option
- VULKAN: Fix secondary screens in overlays not working
- WAYLAND: Implement idle-inhibit support (needed for screensaver suspend)
- WAYLAND: Fix fullscreen toggle
- WIIU: Initial netplay peer-to-peer support. Network information working
- WINDOWS/WSA: Network Information info is blank until first network operation
- WINDOWS: Fix an ancient bug that caused wrong mappings for keyboard arrows
- WINDOWS: Remember window size and position if so desired
- WINDOWS: SSL/TLS connections now work properly
- WINDOWS: Fall back to GDI driver if no accelerated graphics driver is found
- UWP: Initial UWP port
- VFS: Update to version 3
- XBONE: Initial Xbox One port
- XMB/OZONE: Add more icons
- XMB: Add Automatic Inverted theme
- ???: Easter Egg

# 1.7.5
- CAMERA: Fix Video4Linux2 driver that broke years ago
- CONFIG: Add 'Reset To Defaults' setting in Configurations. Thi will reset your config file to defaults
- CHEATS: Add support for Rumble when increase or decrease by the rumble value
- CHEATS: Add cheat variables to allow for updating large portions of memory
- CHEEVOS: Prevent loading states before achievements are fully loaded
- CRT: New porches and interlaced bug fix
- CRT: New functionality, ability to switch between 15KHz and 31KHz, etc
- COMMON: Support for "OEM-102" key (usually '\' on Euro keyboards)
- DISCORD: Add 'Ask To Join' Feature
- EMSCRIPTEN: Add stb_font support
- INPUT: Add new menu toggle combos 'L3 + R' and 'L + R' (useful for Switch)
- IOS: Use safe area to account for notch for iPhone X and adjust main view
- LOCALIZATION: Update Portuguese / Brazilian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Polish translation
- LOCALIZATION: Update Spanish translation
- MENU: Add dropdown lists for many settings
- MENU: Fix crash that could happen when changing core's options on Android
- MENU/QT/WIMP: Add option to rename playlists
- MENU/QT/WIMP: Add option to filter extensions inside archives when adding to a playlist
- MENU/QT/WIMP: Rename playlist entries with 2 single clicks
- MENU/QT/WIMP: Fix shader parameter checkboxes not working
- METAL: Add screenshot support
- NETPLAY: Save lobby details received back from server after first announcement
- OPENGL/GLX: Implement Adaptive VSync - GLX_EXT_swap_control_tear
- OPENGL/WGL: Implement Adaptive VSync - WGL_EXT_swap_control_tear
- RUNAHEAD: Fix performance degradation that could happen over time (after approx. 30 mins). Fixed input IDs outside of range 0-35 causing slow performance in runahead
- SWITCH: Add stb_font support
- SWITCH: Add Retro Achievements support
- SWITCH: Add networking support
- SWITCH: Add touchscreen support
- SWITCH: Add OpenGL support
- SWITCH: Merging of RetroNX Nintendo Switch port, based on libnx SDK
- VULKAN: Fix race condition in threaded mailbox emulation
- VULKAN: Maintenance fixes
- WIIU: Fix menu lag when built with DevKitPro r32

# 1.7.4
- ANDROID: Add sustained performance mode, can be turned on/off in Power Management settings menu
- ANDROID: Powerstate/battery level support
- CHEEVOS: Fix crash when scrolling Achievement List while Unofficial Achievements enabled (#6732)
- CHEEVOS: Added hitcounts support for PauseIf/ResetIf (#6817)
- COMMON: Automatically hide "Configuration Override options" in Quick Menu
- COMMON: Small Bugfix to not trigger savestate code when pressing Reset
- COMMON: Added libsixel video driver
- EMSCRIPTEN: Fix Game Focus Toggle
- HID/OSX: Fix to set hid device registration deterministic (#6497), to address issue #6640 re-adding dynamic device registration
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Polish translation
- LOCALIZATION: Update Portuguese / Brazilian translation
- LOCALIZATION: Update Russian translation
- LOCALIZATION: Update Spanish translation
- MIDI: Add MIDI support to the libretro API. Dosbox is the first proof of concept core implementing libretro MIDI
- MIDI: Add a Windows driver for MIDI, based on winmm
- MENU/QT/WIMP: Qt QSlider styling for Dark Theme
- MENU/QT/WIMP: Remove button ghostly inside highlighting
- MENU/QT/WIMP: Initial grid view
- MENU/QT/WIMP: Drag&drop to add new playlist items, add option to add/edit/delete playlists
- MENU/QT/WIMP: Add menu option to update RetroArch (Windows only for now)
- MENU/QT/WIMP: Add menu option to manage shaders
- MENU/QT/WIMP: Add menu option to manage core options
- MENU/XMB: Add new icons for the settings
- MENU/XMB: Add an option to show the desktop ui
- METAL: Initial work-in-progress video driver for Metal. macOS-only right now, and currently requires macOS 10.13
- METAL: Supports XMB/MaterialUI, has a menu display driver. Has a font rendering driver
- METAL/SLANG: Slang shaders should be compatible with Metal video driver
- NETWORK: Enable SSL/TLS support by default for desktop platforms
- QNX: Fix Game Focus Toggle
- PS3: Add audio mixer support for FLAC and MP3
- PSP: Use proper button labels, fix inverted R-Stick Y axis
- REMAPS: Fix the way offsets are calculated for keyboard remapping
- RUNAHEAD: Fix full-screen mode change breaking Secondary Core's environment variables
- VITA: Use proper button labels, fix inverted R-Stick Y axis
- VITA: Add imc0: mount
- VITA: Use sceCtrlIsMultiControllerSupported to detect
- VULKAN: Fix two validation errors
- VULKAN: Try to avoid creating swapchains redundantly. Should fix black screen and having to alt tab out of window again to get display working on Nvidia GPUs (Windows)
- VULKAN/OSX: Initial MoltenVK support. Not enabled yet, several MoltenVK bugs should be fixed first before we can have it fully working
- WINDOWS/DINPUT: Add rumble support
- WINDOWS/DINPUT: Fix Game Focus Toggle
- WINDOWS/RAWINPUT: Fix Game Focus Toggle
- X11: Fix Game Focus Toggle
- WII: Change deflicker setting to work in 480p or higher, and always enables vfilter so that the user can easily change brightness
- WIIU: Fix out-of-bounds rendering bug
- WIIU: Implement UDP broadcast network logging on Wii U
- WIIU: Audio should no longer clip

# 1.7.3
- AUDIO: Audio mixer supports FLAC/MP3 file types now!
- COMMON: Fixed bug 'crashing in cores that don't range check retro_set_controller_type'. Some people were having crashes when device is set to RETRO_DEVICE_NONE and the cores don't check the number of ports, in VBAM's case it was overflowing and crashing. QuickNES was crashing too
- COMMON: Fixed buffer overflow in url encoding (affecting MSVC2010/2013)
- COMMON: (QuickMenu) Added Configuration Override submenu
- HID: Merge new HID subsystem
- HID: Fix WaveBird support for the Wii U GCA
- HID/OSX: Fix regression with IODHIDManager - gamepads which are connected later would not be autoconfigured
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Portuguese translation
- MENU: New WIMP Qt GUI!
- MENU: Audio mixer now works in the menu without any cores loaded. You have to enable the setting 'Enable menu audio' for this to work
- REMAPPING/OVERLAYS: Fix regression - overlays could no longer be remapped
- SCANNER: Add Wii Backup File WBFS support
- X11: CRT SwitchRes support for X11/Linux

# 1.7.2
- ANDROID/OPENSL: Prevent crashes when setting audio latency too low (buffer count can never be lower than 2 now)
- CRT: Added CRT SwitchRes
- COMMON: Hide the 'Core delete' option if the 'Core updater' is also hidden
- COMMON: Add way to reset core association for playlist entry
- COMMON: Fix invalid long command line options causing infinite loop on Windows
- COMMON: Add OSD statistics for video/audio/core
- COMMON: Added runahead system; allows you to drive down latency even further
- COMMON: Fix buggy behavior that could happen with ZIP file reading on some platforms as a result of not initializing struct
- CHEEVOS: Support Atari 2600, Virtual Boy, and Arcade (only Neo Geo, CPS-1, CPS-2 and CPS-3 and only with fbalpha core)
- CHEEVOS: Add option to automatically take a screenshot when an achievement is triggered
- CHEEVOS: Fixed incompatibilities with Neo Geo Pocket achievement sets
- CHEEVOS: Store only login token, not password
- D3D10: Added D3D10 driver to release build. Has working shaders (Slang), overlay, and menu display driver support. Should be on par capabilities wise
with D3D11 driver except for there being no hardware rendering right now
- D3D11: Experimental hardware renderer. Allows for libretro cores to use D3D11 for hardware rendering. First core to use this is PPSSPP
- D3D11: Increase backwards compatibility, shaders compile with Shader Model 4.0 now, added support for more feature levels
- D3D10/D3D11/D3D12: Fix crashes with completely black or white thumbnail textures in XMB
- GUI: Support disabling window decorations on Windows and Linux
- LIBRETRO: Addition - Functions to enable and disable audio and video, and an environment function to query status of audio and video enables
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Polish translation
- MENU: Add Rewind/Latency/Overlay settings to Quick Menu, add options to show/hide them (User Interface -> Views -> Quick Menu)
- MENU/RGUI: Only show Menu Linear Filter for RGUI and only show it for
video drivers that implement it (D3D8/9/10/11/12/GL)
- MENU/RGUI: Add User Interface -> Appearance options
- MENU/RGUI: D3D8/D3D9: Hookup Menu Linear Filter
- MENU/XMB: Disable XMB shadow icons by default for PowerPC and ARM for performance reasons
- MENU/XMB: Left/right thumbnails are now automatically scaled according to layout
- MENU/XMB: Add Left Thumbnails (additional to the right)
- MENU/XMB: Fixed left/right tab regression
- MENU/XMB: Fix scaling of tall images that were cut on bottom previously
- MENU/XMB: Menu scale factor setting now changes texts length, image scaling and margins
- MENU/XMB: Mouse cursor scales correctly now
- MENU/XMB: Add toggle to show/hide Playlist tabs
- MENU/XMB: Add menu layout - can switch between Desktop, Handheld and Auto
- MENU/XMB: Don't load menu pipeline shaders unless XMB is selected (D3D10/D3D11/D3D12/GL/Vulkan)
- MENU/VIDEO: Only show black frame insertion for the video drivers/context drivers
that support it (so far this includes - D3D8/D3D9, OpenGL, Vulkan)
- MENU/VIDEO:  Only show max swapchain images if supported by video driver and/or context driver (so far this includes - DRM EGL context driver, VideoCore EGL context driver, Vulkan)
- MENU/MaterialUI: Automatic DPI Scaling should be much improved now, now scales as expected at 1440p and 4K resolutions
- MENU/MaterialUI: Fix wrong calculation of an entry height causing long playlists to end up outside of screen range. This also could cause crashes on low DPI screens
- IOS: Fixed crash when opening downloaded roms from Safari or using the "Open in.." functionality. Added the compiler flag to support keyboard remapping to controls
- IOS: Fixed buffer overlap that caused a crash while trying to download GLSL shaders from the buildbot
- PS3: fix URLS
- REMAPS: Mapping keyboard keys from more than one gamepad (works with dosbox)
- REMAPS: Mapping more than one button to the same action
- REMAPS: Unmapping buttons
- REMAPS: Unmapping analogs
- REMAPS: Mapping a button to trigger an analog response (tested with mupen, can run on SM64 with the d-pad now, triggers a full analog tilt)
- REMAPS: Mapping an analog to another analog (having more than one analog mapped to the same output causes issues)
- REMAPS: Mapping an analog to produce a button response
- SCANNER: Should be able to scan dual-layer Wii disc images now, filestream code now supports files larger than 4GB
- SHADERS/SLANG: Slang shaders should work again on Android version and MSVC versions (basically all the Griffin-based versions)
- SHADERS: If GL context is GLES2/3/Core context, Cg shaders are unavailable. Applies to shader list too
- SHADERS: Hide cg/glsl shaders from being able to be selected if D3D8/9/10/11/Vulkan video drivers are selected
- SHADERS: Hide slang shaders from being able to be selected if D3D8/9/OpenGL video drivers are selected
- SHADERS: Prevent crashes from occurring if we have the GL video driver in use and we try to skip to a slang shader through next/previous hotkeys
- SHADERS: Fix shader parameter increase / decrease functions
- SUBSYSTEM: handle savestates properly (cart1 + cart2.state0)
- VULKAN/X11: Fix X11 Vulkan bug from Wayland driver
- VULKAN: Fix multi-line text spacing in menus with Vulkan driver
- WINDOWS XP: Add Cheevos support
- WINDOWS/MSVC 2003/2005/2010/2013/2015/2017: Add Cheevos support
- VITA: Bugfix for 'PS Vita takes many time to start to accept input' issue
- X11: Allow compositor disabling on X11 fullscreen through _NET_WM_BYPASS_COMPOSITOR
- X11: Prioritize _NET_WM_STATE_FULLSCREEN_ in true fullscreen mode
- WIIU: Fix OOB read/write in keyboard driver

# 1.7.1
- 3DS: Now correctly reports amount of CPU cores
- 3DS: Frontend rating is now correctly implemented for both New 3DS/2DS and Old 3DS/2DS
- 3DS: Initial networking support, HTTP requests won't work yet
- 3DS: Now reports memory and battery state
- AUDIO: Added 'Audio Resampler Quality' setting to Audio Settings. Setting this higher will increase sound quality at the expense of sound latency and/or performance. Setting this value lower will improve sound latency/performance at the expense of sound quality. Only has an effect if the Sinc resampler is used, and you have to restart the game for changes to take effect
- CHEEVOS: Fix unofficial achievements not being loaded
- CHEEVOS: Show savestate menu entries when no achievements are found even if hardcore mode is enabled
- CHEEVOS: Support Neo Geo Pocket
- COMMON: Bugfix for issue related to 'Windows mouse pointer visible when running MESS or MAME cores'
- COMMON: Fix bug 'Last item in a Playlist is ignored'
- COMMON: New LED API. Driver implemented for Raspberry Pi, proof of concept implemented for core MAME 2003
- COMMON: Add quick menu option to watch shader files for changes and recompile them automatically (Linux only for now)
- D3D8: Direct3D 8 can now work on systems that have Direct3D 8 installed
- D3D9: Add menu support for MaterialUI/XMB
- D3D10: Initial video driver implementation
- D3D11: Initial video driver implementation
- D3D11: SPIRV-Cross/slang shader support for D3D11
- D3D12: Initial video driver implementation
- DINPUT: don't reinitialize input driver on network events / media insertion / network drive connection
- INPUT: show friendly names when available under input binds and system information
- INPUT: show the config name when available under system information
- GUI: Allow changing menu font color
- GUI: Menu visibility options for RGUI and MaterialUI
- GUI/MaterialUI: Works now with D3D8, D3D9 Cg, D3D11 and D3D12 drivers
- GUI/XMB: Add Monochrome Inverted icon theme
- GUI/XMB: Allow changing menu scale to 200%
- GUI/XMB: Works now with D3D8, D3D9 Cg, D3D11 and D3D12 drivers. Menu shader effects currently don't work on D3D8/D3D9 Cg
- HAIKU: Restored port
- KEYMAPPER: prevent a condition that caused input_menu_toggle to stop working when a RETRO_DEVICE_KEYBOARD type device is enabled
- GL: ignore hard gpu sync when fast-forwarding
- IOS10/11: Handle hardware keyboards and iCade controllers
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Portuguese-Brazilian translation
- LOCALIZATION: Update Spanish translation
- NETPLAY: Add menu option to select different MITM (relay) server locations
- OSX: Modify HID buttons detection algorithm
- QB: Added --datarootdir, --sysconfdir, --bindir, --docdir and --mandir
- QB: Deprecated --global-config-dir, --with-bin_dir and --with-man_dir
- SHADERS: Allow saving of shader presets based on the parent directory (Saving one for */foo/bar/mario.sfc* would result in *shaders/presets/corename/bar.ext*). We decided it's safer to still isolate the presets to a single core because different cores may treat video output differently
- SHADERS: Don't save the path to the current preset to the main config. This was causing weird behavior, instead it will try to load *currentconfig.ext* and it will save a preset with that name when select *apply shader preset*. The resulting shader will restore properly after restarting and even after core/parent/game specific presets are loaded
- SOLARIS: Initial port
- SWITCH: Initial Nintendo Switch port, based on libtransistor SDK
- PS3: Enable Cheevos
- PSP: Enable threading support through pthreads
- SHADERS: SPIRV-Cross/slang shader support for D3D11
- SHIELD ATV: Allow the remote / gamepad takeover hack to work with the 2017 gamepad
- SUBSYSTEM: Subsystem saves now respect the save directory
- SUBSYSTEM: You can now load subsystem games from the menu (see https://github.com/libretro/RetroArch/pull/6282 for caveats)
- VULKAN: Fix swapchain recreation bug on Nvidia GPUs with Windows 10 (resolved in Windows Nvidia driver version 390.77)
- WINDOWS: Improved Unicode support (for cores/directory creation and 7zip archives)
- WINDOWS: Show progress meter on taskbar for downloads (Windows 7 and up)
- WINDOWS: WS_EX_LAYERED drastically decreases performance, so only set it when needed (transparency in windowed mode)
- WIIU: Overlay support
- WIIU: Transparency support in menu + overlays
- WIIU: Increased stability during core switching
- WIIU: Shader support
- WIIU: Menu shader effects added (shaders)
- WIIU: Add missing time/clock support. (also fixes RTC [Real Time Clock] in Gambatte)
- XBOX OG: Restored port

# 1.7.0
- CHEEVOS: Add badges for achievements, shows thumbnail images of achievements
- CHEEVOS: Leaderboard support
- CHEEVOS: Only disable savestates on hardcore mode if achievements are not available
- COMMANDLINE: Fix fullscreen toggle switch
- COMMON: Add 'Automatically Load Content To Playlist' feature, enabled by default
- COMMON: Fix slowmotion ratio always being reset back to 1
- COMMON: Optimized NBIO implementations now for Apple, Windows, and Linux. Uses mmap for Linux/Windows/BSD if/when available. File I/O should now be much faster for loading images inside the menu
- COMMON: Native Blissbox support now for latest firmware as of writing (2.0). Implementation through libusb and/or native Windows HID
- COMMON: New lightgun API
- COMMON: New VFS (Virtual File System) API
- COMMON: Fixed some playlist bugs
- COMMON: New snow shader
- COMMON: Fix Quick Menu title, no longer shows 'Select File'
- COMMON: Fix loading cores that require no content one after another
- COMMON: Map Delete key to Y button for non-unified menu keyboard controls
- COMMON: Fix for relative paths being normalised and generating a duplicate history entry
- EMSCRIPTEN: Fix references to browserfs
- FREEBSD: Support libusb HID input driver
- HAIKU: Buildfix
- INPUT: Map clear button to DEL key
- LINUX/X11: Add RetroArch logo to window title bar
- LINUX/X11: Input driver now supports new lightgun code
- LINUX/X11: Support window transparency (requires a compositing window manager)
- LOBBIES: Fix for crash on join netplay rooms via touch / glui
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Portuguese-Brazilian translation
- LOCALIZATION: Update Polish translation
- LOCALIZATION: Update Russian translation
- MENU: Snowflake menu shader effect
- OSX/PPC: Fix the GL2 renderchain, had to use EXT versions of framebuffer/renderbuffer functions
- PS3: HTTP requests / downloads should now work
- PS3: Core Updater now works
- PS3: Improved font rendering, enable STB Unicode font renderer
- PSP: Make it work with Vita's Adrenaline
- PSP: Fix audio sync
- PSP: Fix content loading, port should be functional again
- PSP: Use 64MB when available
- SCANNER: Fix crash from Windows-incompatible format string
- VITA: Improve packaging, installation times
- WIIU: Disabled the controller patcher for now since it was the source of many stability issues
- VULKAN: Various stability fixes for WSI
- WINDOWS: Add MSVC 2017 solution
- WINDOWS: Get rid of the empty console window in MSVC 2010 builds
- WINDOWS: Raw input driver now supports new lightgun code
- WINDOWS: Use configured OSD/text message color on GDI driver
- WINDOWS/XINPUT: Populate XInput VID/PID from DInput so autoconfig doesn't rely solely on joypad names
- WINDOWS/XINPUT: Fix crash that occurs in some situations with Steam running and a Steam Controller plugged in
- WINDOWS: Improve version reporting under System Information
- WINDOWS: Support window transparency
- WINDOWS: Correct usage of GetWindowPlacement per MS docs, fixes game window position on Win95/98
- WINDOWS: Added Visual Studio 2017 support

# 1.6.9
- COMMON: Small memory leak
- NETPLAY: Fix network command only working once

# 1.6.8
- Audio: Fix the Audio DSP picker
- CHEEVOS: Add support for Atari Lynx cheevos
- CHEEVOS: Add support for RetroAchievements Leaderboards
- GUI: (MaterialUI) Fix crash that happened on context reset with Vulkan
- GUI: (MaterialUI) Skip querying and drawing items that are not visible; Cache content height and bbox calculation
- GUI: (MaterialUI) Fix entry box highlight calculation
- GUI: (XMB) Skip drawing the fading list when it is already transparent. Optimization
- GUI: (XMB) Comment out visible item calculation in xmb_draw_items()
- GUI: (RGUI) Prevent crashes when using a non-English language reliant on UTF8
- GUI: Add menu option for OSD background color
- GUI: Add menu option for OSD text color
- GUI: Add menu option to remove frame count from OSD
- GUI: Allow wraparound of int/float settings when pressing the left key
- INPUT/LIBRETRO: Add support for more mouse buttons (buttons 4/5)
- INPUT/LIBRETRO: Add support for analog buttons
- INPUT: Always show the controls menu even if descriptors are not set
- INPUT: Fix input descriptors not being set on cores that don't implement the controllers interface
- INPUT: Apply descriptors only for the amount of cores the core supports
- INPUT: Implement keyboard to gamepad input remapping (limited to one gamepad device for now)
- INPUT: Fix absolute mouse move handling on the winraw driver
- INPUT: Ignore keyboard input if window is not active on udev driver
- INPUT: Sanitize the filenames of autoconfig profiles before saving
- LOBBIES: Fix crash on navigating left / right from the lobby menu
- LOCALIZATION: Update Dutch translation
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Portuguese-Brazilian translation
- LOCALIZATION: Update Russian translation
- LINUX/ARMHF: Set buildbot updater URL to armhf location instead of blank string
- LINUX/PI: Broadcom VC4: Add Videocore config option
- LINUX/UDEV: Fix - RetroArch reads keyboard input when not focused with the udev input driver
- NETPLAY: Fix disconnection not fully deinitializing Netplay
- NETPLAY: Fix lan rooms when there is more than one room
- NETPLAY: Fix lan rooms on systems where all addresses are treated as IPv6
- COMMON: Fix clear/free loop conditionals in playlists
- WINDOWS/GDI: Fix flickering of text
- WINDOWS/GDI: Fix graphics corruption on Windows 98
- WINDOWS/GDI: Allow compiling without DirectInput8 for NT support
- WINDOWS/WGL: Try to use wglSwapLayerBuffers instead of SwapBuffers if possible (for more optimal performance)
- WINDOWS: Fix menubar text corruption on Japanese locale systems
- WINDOWS: Support Unicode file I/O (can now display CJK characters in file browser for example)
- WINDOWS: Support Windows 95, NT3.51, NT4
- WINDOWS: add Makefile.griffin targets for msvc6,2003,2005,2010,2012,2013
- WII: Use custom, embedded libogc SDK
- WIIU: Initial touchscreen support for WiiU gamepad
- WIIU: Add Cheevos support
- SCANNER: Fix archive scanning
- SCANNER: Support CHD files
- SCANNER: Support Gamecube ISO scanning
- SCANNER: Use primary data track of disc images for CRC lookups rather than cue files.  This is slower but finds matches more reliably, and is necessary for CHD files to work at all.  Update your databases!
- SCANNER: Fall back on looking inside archives when matching MAME/FBA content (most recent cores only).  If you had difficulty with content being detected before, you may have better luck now.  Update your databases and core info!

# 1.6.7
- SCANNER: Fix directory scanning
- SCANNER: Fix file scanning
- COMMON: Fix 'Disk Image Append' option
- FREEBSD: Compatibility fixes for Video4Linux2 camera driver
- GUI: (MaterialUI) Add disk image append icons
- GUI: (MaterialUI) Improve word wrapping when menu icons are enabled
- GUI: (MaterialUI) Add User Interface -> Appearance -> Menu Icons Enable. You can turn on/off the icons on the lefthand side of the menu entries
- GUI: Performance optimizations for XMB menu driver - only calculates visible items
- LOCALIZATION: Update Italian translation

# 1.6.6
- 3DS: Fixes serious performance regression that affected every core; rewind was always implicitly enabled
- AUDIO: MOD/S3M/XM sound should now be properly mixed in with the core's sound
- GUI: Visual makeover of MaterialUI
- GUI: Added 'Music', 'Images' and 'Video' collection options to RGUI/MaterialUI
- GUI: Allow the user to add 'Favorites'
- GUI: Allow the user to rename entries
- GUI: Performance optimizations for XMB menu driver
- LOCALIZATION: Update Italian translation
- INPUT: Overlay controller response - when we press buttons on the gamepad or keyboard, the corresponding buttons on the overlay will be highlighted as well
- NETBSD: Silence some compilation warnings
- COMMON: Fixed bug 'Deleting an entry from a playlist would not update the list view inside XMB'
- COMMON: Fix inet_ntop_compat on Unix
- LOBBY: Add skeleton to add help descriptions to lobbies

# 1.6.5
Skipped this one

# 1.6.4

- ANDROID: Fire Stick & Fire TV remote overrides gamepad port 0 on button press and viceversa like SHIELD devices
- ANDROID: Provide default save / system / state / screenshot locations
- AUDIO: Audio mixer supports MOD/S3M/XM file types now!
- INPUT: input swap override flag (for remotes) is cleared correctly
- INPUT: allow specifying libretro device in remap files
- INPUT: allow specifying analog dpad mode in remap files
- INPUT: allow saving libretro device to remap files
- INPUT: allow saving analog dpad mode to remap files
- INPUT: allow removing core and game remap files from the menu
- COMMON: Cores can now request to set a 'shared context'. You no longer need to explicitly enable 'Shared Hardware Context' for Citra/OpenLara/Dolphin
- COMMON: Add 'Delete Core' option to Core Information menu
- COMMON: Allow Max Timing Skew to be set to 0
- COMMON: Change the "content dir" behavior so it works on either a flag or an empty directory setting, now platform drivers can provide defaults for save / system / state / screenshot dirs and still allow the content dir functionality, these settings are under settings / saving and flagged as advanced
- GUI: You can turn on/off 'Horizontal Animation' now for the XMB menu. Turning animations off can result in a performance boost
- GUI: Fix sublabel word-wrapping in XMB where multi-byte languages were cut off too soon
- LOCALIZATION: Update Dutch translation
- LOCALIZATION: Update Traditional Chinese translation
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Russian translation
- WINDOWS: Provide default save / system / state / screenshot locations
- LOBBIES: Show what country the host is in
- MENU: Enable OSD text rendering for gdi and libcaca drivers
- WINDOWS 98/ME/2K: Set default directory for MSVC 2005 RetroArch version
- WII: Better V-Sync handling, backported from SuperrSonic
- WIIU: Exception handler rewritten

# 1.6.3
- IOS: Fix GL regression - 32bit color format cores were no longer rendering
- CHEEVOS: Add support for N64 cheevos and other small fixes
- CHEEVOS: Add 'Achievements -> Achievements Verbose Mode'. Ability to display cheevos related messages in OSD, useful for RetroAchievements users
- AUDIO: Audio mixer's volume can now be independently increased/decreased, and muted
- AUDIO: Mute now no longer disables/enables audio but instead properly mutes the audio volume. Mute is also independent from the audio mixer volume
- INPUT: Add mouse index selection; ability now to select between different mice
- INPUT: Fix 'All Users Control Menu' setting
- LINUX: Add a tinyalsa audio driver. Doesn't require asoundlib, should be self-contained and lower-level
- LOBBIES: Announce the RetroArch version too
- LOCALIZATION: Add Traditional Chinese translation
- LOCALIZATION: Update French translation
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Russian translation
- MENU: Add 'User Interface -> Views'. Ability to display/hide online updater and core updater options
- NETPLAY: Disconnecting one client shouldn't cause everyone to disconnect anymore
- NETWORK: SSL/TLS support, disabled by default
- SCANNER: Fix PS1 game scanning
- SCANNER: Move content list builder into scanner task with progress, fixes menu freeze with large playlists
- SDL2: Fix 'SDL2 driver does not see the hat on wired Xbox 360 controller"
- SETTINGS: Fix regression 'Custom Viewport is no longer overridable per-core or per-game'
- VITA: Add cheevos support
- VITA: Add support for external USB if mounted
- WAYLAND: Fix menu mouse input
- WII: Add support for single-port 'PS1/PS2 to USB controller adapter

# 1.6.0
- ANDROID: Allow remotes to retain OK/Cancel position when menu_swap_ok_cancel is enabled
- ANDROID: Improve autoconf fallback
- ANDROID: Improve shield portable/gamepad device grouping workaround
- ANDROID: Runtime permission checking
- AUDIO: Audio mixer support. Mix up to 8 streams with the game's audio
- AUTOSAVE/SRAM - Fix bug #3829 / #4820 (https://github.com/libretro/RetroArch/issues/3829)
- ENDIANNESS: Fixed database scanning. Should fix scanning on PS3/WiiU/Wii, etc
- LOBBIES: Fallback to filename based matching if no CRC matches are found (for people making playlists by hand)
- LOBBIES: GUI refinement, show stop hosting when a host has been started, show disconnect when playing as client
- LOBBIES: if the game is already loaded it will try to connect directly instead of re-loading content (non-fullpath cores only)
- LOBBIES: unify both netplay menus
- LOCALIZATION/GUI: Korean font should display properly now with XMB/MaterialUI's default font
- LOCALIZATION: Update German translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Russian translation
- LOCALIZATION: Update/finish French translation
- MENU: Improved rendering for XMB ribbon; using additive blending (Vulkan/GL)
- MISC: Various frontend optimizations
- NET: Fix bug #4703 (https://github.com/libretro/RetroArch/issues/4703)
- OSX/MACOS: Fixes serious memory leak
- THUMBNAILS: Thumbnails show up now in Load Content -> Collection, Information -> Database
- VIDEO: Fix threaded video regression; tickering of menu entries would no longer work
- VITA: Fix 30fps menu (poke into input now instead of reading the entire input buffer which apparently is slow)
- VITA: Fix frame throttle
- VITA: Fix slow I/O
- VULKAN: Fix some crashes on loading some thumbnails
- VULKAN: Unicode font rendering support. Should fix bad character encoding for French characters, etc
- WII: Fix crashing issues which could occur with the dummy core
- WIIU: HID Controller support
- WIIU: Initial network/netplay support
- WIIU: XMB/MaterialUI menu driver support
- WINDOWS: Added RawInput input driver for low-latency, low-level input
- WINDOWS: Added WASAPI audio driver for low-latency audio. Both shared and exclusive mode
- WINDOWS: Core mouse input should be relative again in cores

# 1.5.0
- ANDROID: Autoconf fallback
- ANDROID: Mouse support / Emulated mouse support
- AUTOCONF: Fix partial matches for pad name
- CHEEVOS: Fix crashes in the cheevos description menu
- CHEEVOS: WIP leaderboards support
- COMMON: 9-slice texture drawing support
- COMMON: Threading fixes
- CORETEXT/APPLE: Ability to load menu display font drivers and loading of custom font
- DOS: Add keyboard driver
- DOS: Improve color accuracy and scaling
- GUI: Add a symbol page in the OSK
- GUI: Allow changing icon theme on the fly
- GUI: Better dialogs for XMB
- GUI: Various settings are now only visible when advanced settings is enabled
- LOCALIZATION: Add/update Korean translation
- LOCALIZATION: Rewrite German translation
- LOCALIZATION: Update several English sublabels
- LOCALIZATION: Update several Japanese labels
- MOBILE: Long-tap a setting to reset to default
- MOBILE: Single-tap for menu entry selection
- NET: Allow manual netplay content loading
- NET: Announcing network games to the public lobby is optional now
- NET: Bake in miniupnpc
- NET: Fix netplay join for contentless cores
- NET: Fix netplay rooms being pushed on the wrong tab
- NET: Lan games show next to lobbies with (lan) and connect via the private IP address
- NET: Use new lobby system with MITM support
- NUKLEAR: Update to current version
- SCANNER: Always add 7z & zip to supported extensions
- VULKAN: Add snow/bokeh shader pipeline effects - at parity with GL now
- VULKAN: Find supported composite alpha in swapchain
- WIIU: Keyboard support
- WINDOWS: Fix loading of core/content via file menu
- WINDOWS: Logging to file no longer spawns an empty window

# 1.4.1


